package examples.entity.uni.one_to_one.client;

import javax.naming.InitialContext;
import javax.naming.NamingException;

import examples.entity.uni.one_to_one.Order;
import examples.entity.uni.one_to_one.interfaces.OrderShipment;


public class OrderShipmentClient {
	public static void main(String[] args) {
		try {
			InitialContext ic = new InitialContext();
			OrderShipment os = (OrderShipment)ic.lookup(OrderShipment.class.getName());
			
			os.doSomeStuff();
			
			System.out.println("Unidirectional One-To-One client\n");
			
			for (Object o : os.getOrders()) {
				Order order = (Order)o;
				System.out.println("Order "+order.getId()+": "+order.getOrderName());
				System.out.println("\tShipment details: "+order.getShipment().getCity()+" "+order.getShipment().getZipcode());
			}
		} 
		catch (NamingException e) {
			e.printStackTrace();
		}
	}
}
